using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Ini;
using System.IO;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Threading;


namespace Mobi2Mobi_GUI
{
    public partial class Form1 : Form
    {
        public static string sOpenedBook;
        public static string sOpenedImage;
        public static string sCoverImagePreview;
        public static string sThumbnailImagePreview;
        public static string sOpenedImageOutput;
        public static string sOpenedTNImage;
        public static string sOpenedTNImageOutput;
        public static string sGen3FixOutput;
        public static string sBookTitle;
        public static string sLongTitle;
        public static string sBookAuthor;
        public static string sBookAuthorResult;
        public static string sBookAuthorOutput;
        public static string sBookPublisher;
        public static string sBookPublisherResult;
        public static string sBookPublisherOutput;
        public static string sBookSubject;
        public static string sBookSubjectResult;
        public static string sBookSubjectOutput;
        public static string sBookDescription;
        public static string sBookDescriptionResult;
        public static string sBookDescriptionOutput;
        public static string sBookLanguage;
        public static string sBookLanguageResult;
        public static string sBookLanguageOutput;
        public static string sFilenameTrimmed;
        public static string sFilenameOutput;
        public static string sFilenameOutputMod;
        public static string sFilenameOutputCheck;
        public static string sFilenameOutputFinal;
        public static string sCoverImagePreviewPath;
        public static string sThumbnailImagePreviewPath;
        public static string sCoverImagePreviewPathBatch;
        public static string sThumbnailImagePreviewPathBatch;
        public static string sOutPutPath;
        public static string sDatafileDetail;
        public static string sLongfileDetail;
        public static string sSearchResult;
        public static string[] sSplit;
        public static string[] sSplitData;
        public static string content;
        public static string sMobiDataPathBatch;
        public static string sMobiDataPath;
        public static string sTmpBookPath;
        public static string sTmpBookPathBatch;
        public static string sMobi2MobiPath;
        public static string sM2MBatchPath;
        public static string sFilterExtn;
        public static string sExth1;
        public static string sExth1Output;
        public static string sExth2;
        public static string sExth2Output;
        public static string sExth3;
        public static string sExth3Output;

        
        public Form1()
        {
            InitializeComponent();
        }

        private void btnOpenFile_Click(object sender, EventArgs e)
        {
            if (lblMobi2MobiNotFound.Visible == true)
            {
                MessageBox.Show("Please select the location of the Mobi2Mobi Win32 or Perl file.");
            }
            else
            {
                InitFields();

                OpenFileDialog openFileDialog1 = new OpenFileDialog();
                openFileDialog1.InitialDirectory = @"" + tbWorkingDir.Text + "";
                openFileDialog1.Filter = "MobiPocket (*.prc, *.mobi)|*.prc;*.mobi";
                openFileDialog1.Title = "Select a MobiPocket PRC File";

                BuildPaths();

                DelFile(sTmpBookPath);
                DelFile(sCoverImagePreviewPath);
                DelFile(sThumbnailImagePreviewPath);

                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    sOpenedBook = openFileDialog1.FileName;
                    tbOpenedFile.Text = openFileDialog1.SafeFileName;
                    sOutPutPath = LeftOf(sOpenedBook, tbOpenedFile.Text);
                    sFilterExtn = RightOf(sOpenedBook, ".");
                    sOpenedBook = "\"" + sOpenedBook + "\"";

                    BuildBatch(sM2MBatchPath, sMobi2MobiPath + " " + sOpenedBook + " --outfile " + sTmpBookPathBatch + " --savecover " + sCoverImagePreviewPathBatch + " --savethumb " + sThumbnailImagePreviewPathBatch);

                    BatchProcess(sM2MBatchPath, false);

                    DelFile(sM2MBatchPath);

                    BuildBatch(sM2MBatchPath, sMobi2MobiPath + " " + sTmpBookPathBatch + " > " + sMobiDataPathBatch);

                    BatchProcess(sM2MBatchPath, false);

                    UpdateCoverImagePB(sCoverImagePreviewPath);
                    UpdateThumbnailImagePB(sThumbnailImagePreviewPath);

                    DelFile(sM2MBatchPath);

                    sFilenameOutput = LeftOf(tbOpenedFile.Text, ".");
                    tbOutputFile.Text = sFilenameOutput;
                    sFilenameOutputCheck = sFilenameOutput;
                    sFilenameOutputFinal = "--outfile " + "\"" + sOutPutPath + sFilenameOutput + ".mobi" + "\"";

                    UpdateBookFields(sMobiDataPath, true);

                    sBookTitle = tbBookTitle.Text;
                    sLongTitle = tbBookTitle.Text;
                    sLongTitle = "--title " + "\"" + sLongTitle + "\"" + " ";

                    DelFile(sMobiDataPath);
                }
            }
        }

        public static string LeftOf(string stream, string stringToStopAt)
        {
            try
            {
                if (stringToStopAt == null || stringToStopAt == string.Empty)
                    return stream;

                int stringLength = stream.Length;
                int findLength = stringToStopAt.Length;

                stringToStopAt = stringToStopAt.ToLower();
                string temp = stream.ToLower();
                int i = temp.IndexOf(stringToStopAt);

                if ((i <= -1) && (stringToStopAt != temp.Substring(0, findLength))
                    || (i == -1))
                    return stream;

                string result = stream.Substring(0, i);
                return result;
            }
            catch (Exception)
            {
                //ErrorTool.ProcessError(ex);
                return null;
            }
        }

        public static string RightOf(string stream, string stringToStartAfter)
        {
            try
            {
                if (stringToStartAfter == null || stringToStartAfter == string.Empty)
                    return stream;

                stringToStartAfter = stringToStartAfter.ToLower();
                string temp = stream.ToLower();
                int findLength = stringToStartAfter.Length;
                int i = temp.IndexOf(stringToStartAfter);

                if ((i <= -1) && (stringToStartAfter != temp.Substring(0, findLength))
                    || (i == -1))
                    return stream;

                string result =
                    stream.Substring(i + findLength, stream.Length - (i + findLength));
                return result;
            }
            catch (Exception)
            {
                //ErrorTool.ProcessError(ex);
                return null;
            }
        }

        private void cbBookTitle_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbBookTitle.Checked == true)
            {
                sLongTitle = tbBookTitle.Text;
                if (sBookTitle != sLongTitle == true)
                {
                    sLongTitle = "--title " + "\"" + sLongTitle + "\"" + " ";
                }
                else
                {
                    sLongTitle = sBookTitle;
                    cbBookTitle.Checked = false;
                    MessageBox.Show("You didn't make any changes to the Book Title.");
                }
            }

            if (this.cbBookTitle.Checked == false)
            {
                sLongTitle = sBookTitle;
                sLongTitle = "--title " + "\"" + sLongTitle + "\"" + " ";
            }

        }

        private void tbBookTitle_TextChanged(object sender, EventArgs e)
        {
            if (tbBookTitle.Text != sBookTitle == true)
            {
                cbBookTitle.Checked = false;
            }

        }

        private void cbAuthorDetail_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbAuthorDetail.Checked == true)
            {
                sBookAuthor = tbAuthorDetail.Text;
                if (sBookAuthor.Length > 0)
                {
                    sBookAuthorOutput = "--author " + "\"" + sBookAuthor + "\"" + " ";
                }
                else
                {
                    sBookAuthor = "";
                    cbAuthorDetail.Checked = false;
                    MessageBox.Show("Please enter Authors name before checking this box again.");
                }
            }

            if (this.cbAuthorDetail.Checked == false)
            {
                sBookAuthorOutput = "";
            }
        }

        private void cbPublisherDetail_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbPublisherDetail.Checked == true)
            {
                sBookPublisher = tbPublisherDetail.Text;
                if (sBookPublisher.Length > 0)
                {
                    sBookPublisherOutput = "--publisher " + "\"" + sBookPublisher + "\"" + " ";
                }
                else
                {
                    sBookPublisher = "";
                    cbPublisherDetail.Checked = false;
                    MessageBox.Show("Please enter the Publishers details before checking this box again.");
                }
            }

            if (this.cbPublisherDetail.Checked == false)
            {
                sBookPublisherOutput = "";
            }
        }

        private void cbOutputFile_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbOutputFile.Checked == true)
            {
                sFilenameOutputMod = tbOutputFile.Text;
                if (sFilenameOutput != sFilenameOutputMod == true)
                {
                    sFilenameOutputCheck = sFilenameOutputMod;
                    sFilenameOutputFinal = "--outfile " + "\"" + sOutPutPath + sFilenameOutputMod + ".mobi" + "\"";
                }
                else
                {
                    sFilenameOutputMod = sFilenameOutput;
                    sFilenameOutputCheck = sFilenameOutputMod;
                    cbOutputFile.Checked = false;
                    MessageBox.Show("You didn't make any changes to the output filename.");
                }
            }

            if (this.cbOutputFile.Checked == false)
            {
                sFilenameOutputMod = sFilenameOutput;
                sFilenameOutputCheck = sFilenameOutputMod;
                sFilenameOutputFinal = "--outfile " + "\"" + sOutPutPath + sFilenameOutputMod + ".mobi" + "\"";
            }
        }

        private void tbOutputFile_TextChanged(object sender, EventArgs e)
        {
            if (sFilenameOutput != tbOutputFile.Text == false)
            {
                cbOutputFile.Checked = false;
            }
        }

        private void btnProcess_Click(object sender, EventArgs e)
        {
            if (tbOpenedFile.Text.Length <= 0)
            {
                MessageBox.Show("Please open a Mobipocket eBook for conversion and try again.");
            }
            else
            {
                //BuildBatch(sM2MBatchPath, sMobi2MobiPath + " " + sTmpBookPathBatch + " " + sLongTitle + sBookAuthorOutput + sBookPublisherOutput + sBookSubjectOutput + sBookDescriptionOutput + sBookLanguageOutput + sExth1Output + sExth2Output + sExth3Output + sOpenedImageOutput + sOpenedTNImageOutput + sGen3FixOutput + sFilenameOutputFinal);
                BuildBatch(sM2MBatchPath, sMobi2MobiPath + " " + sTmpBookPathBatch + " " + sLongTitle + sBookAuthorOutput + sBookPublisherOutput + sBookSubjectOutput + sBookDescriptionOutput + sBookLanguageOutput + sExth1Output + sOpenedImageOutput + sOpenedTNImageOutput + sGen3FixOutput + sFilenameOutputFinal);

                BatchProcess(sM2MBatchPath, false);

                DelFile(sTmpBookPath);

                DelFile(sM2MBatchPath);

                BuildBatch(sM2MBatchPath, sMobi2MobiPath + " " + "\"" + sOutPutPath + sFilenameOutputCheck + ".mobi" + "\"");

                rtbMobiOutput.Text = BatchProcess(sM2MBatchPath, true);

                DelFile(sM2MBatchPath);

                //Reload New Converted File
                pbCoverImage.Image = null;
                pbThumbnail.Image = null;

                DelFile(sCoverImagePreviewPath);
                DelFile(sThumbnailImagePreviewPath);

                sOpenedBook = sOutPutPath + sFilenameOutputCheck + ".mobi";
                tbOpenedFile.Text = sFilenameOutputCheck + ".mobi";
                sOutPutPath = LeftOf(sOpenedBook, tbOpenedFile.Text);
                sOpenedBook = "\"" + sOpenedBook + "\"";

                BuildBatch(sM2MBatchPath, sMobi2MobiPath + " " + sOpenedBook + " --outfile " + sTmpBookPathBatch + " --savecover " + sCoverImagePreviewPathBatch + " --savethumb " + sThumbnailImagePreviewPathBatch);

                BatchProcess(sM2MBatchPath, false);

                DelFile(sM2MBatchPath);

                BuildBatch(sM2MBatchPath, sMobi2MobiPath + " " + sTmpBookPathBatch + " > " + sMobiDataPathBatch);

                BatchProcess(sM2MBatchPath, false);

                UpdateCoverImagePB(sCoverImagePreviewPath);
                UpdateThumbnailImagePB(sThumbnailImagePreviewPath);

                DelFile(sM2MBatchPath);
                sFilenameOutput = LeftOf(tbOpenedFile.Text, ".");
                tbOutputFile.Text = sFilenameOutput;
                sFilenameOutputCheck = sFilenameOutput;
                sFilenameOutputFinal = "--outfile " + "\"" + sOutPutPath + sFilenameOutput + ".mobi" + "\"";

                UpdateBookFields(sMobiDataPath, false);

                sBookTitle = tbBookTitle.Text;
                sLongTitle = tbBookTitle.Text;
                sLongTitle = "--title " + "\"" + sLongTitle + "\"" + " ";

                DelFile(sMobiDataPath);

                cbOutputFile.Checked = false;
                cbBookTitle.Checked = false;
                cbAuthorDetail.Checked = false;
                cbPublisherDetail.Checked = false;
                cbSubject.Checked = false;
                cbDescription.Checked = false;
                cbLanguage.Checked = false;
                cbThumbnail.Checked = false;
                cbCoverImage.Checked = false;
                cbGen3Fix.Checked = false;
                cbExth1.Checked = false;
                //cbExth2.Checked = false;
                //cbExth3.Checked = false;
                tbCoverImage.Text = "";
                tbExthdata1.Text = "";
                //tbExthdata2.Text = "";
                //tbExthdata3.Text = "";
                cmbLanguage.SelectedIndex = -1;
                cmbExthType1.SelectedIndex = -1;
                //cmbExthType2.SelectedIndex = -1;
                //cmbExthType3.SelectedIndex = -1;
            }
        }



        private void Form1_Load(object sender, EventArgs e)
        {
            IniFile ini = new IniFile(".\\m2mcfg.ini");
            tbWorkingDir.Text = ini.IniReadValue("Config", "WorkingDir");
            tbMobi2MobiDir.Text = ini.IniReadValue("Config", "MobiDir");

            if (tbMobi2MobiDir.Text.Length <= 0)
            {
                MessageBox.Show("Please select the location of the Mobi2Mobi Win32 or Perl file.");
                cbUsePerl.Visible = false;
                cbUseWin32.Visible = false;
            }
            else
            {
                string sMobi2MobiPL = tbMobi2MobiDir.Text + "\\mobi2mobi.pl";
                string sMobi2MobiEXE = tbMobi2MobiDir.Text + "\\mobi2mobi.exe";
                int iMobi2MobiCount = 0;

                if (File.Exists(sMobi2MobiPL) == true)
                {
                    cbUsePerl.Visible = true;
                    iMobi2MobiCount = iMobi2MobiCount + 1;
                }
                else
                {
                    cbUsePerl.Visible = false;
                }

                if (File.Exists(sMobi2MobiEXE) == true)
                {
                    cbUseWin32.Visible = true;
                    iMobi2MobiCount = iMobi2MobiCount + 1;
                }
                else
                {
                    cbUseWin32.Visible = false;
                }

                if (iMobi2MobiCount > 0)
                {
                    lblMobi2MobiNotFound.Visible = false;
                }
                else
                {
                    lblMobi2MobiNotFound.Visible = true;
                }
            }

            if (ini.IniReadValue("Config", "UsePerl") == "true")
            {
                cbUsePerl.Checked = true;
            }
            else
            {
                cbUsePerl.Checked = false;
            }

            if (ini.IniReadValue("Config", "UseWin32") == "true")
            {
                cbUseWin32.Checked = true;
            }
            else
            {
                cbUseWin32.Checked = false;
            }

        }

        private void btnWorkingDir_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderDialog = new FolderBrowserDialog();
            folderDialog.ShowNewFolderButton = false;
            folderDialog.SelectedPath = @"C:\";
            folderDialog.Description = "Select the directory your eBooks reside in.";

            if (folderDialog.ShowDialog() == DialogResult.OK)
            {
                tbWorkingDir.Text = folderDialog.SelectedPath;
                IniFile ini = new IniFile(".\\m2mcfg.ini");
                ini.IniWriteValue("Config", "WorkingDir", tbWorkingDir.Text);
            }
        }

        private void tbAuthorDetail_TextChanged(object sender, EventArgs e)
        {

        }

        private void rtbMobiOutput_TextChanged(object sender, EventArgs e)
        {

        }

        //public static List<string> GetLines(string source, string pattern, bool isFileName)
        public static string GetLines(string source, string pattern, bool isFileName)
        {
            string text = source;
            string sResult = "";

            // If this is a file, get the entire file's text.
            if (isFileName)
            {
                using (FileStream FS = new FileStream(source, FileMode.Open, FileAccess.Read, FileShare.Read))
                {
                    using (StreamReader SR = new StreamReader(FS))
                    {
                        Regex RE = new Regex(pattern, RegexOptions.Multiline);
                        while (text != null)
                        {
                            text = SR.ReadLine();

                            if (text != null)
                            {
                                // Run the regex on each line in the string.
                                MatchCollection theMatches = RE.Matches(text);

                                if (theMatches.Count > 0)
                                {

                                    // Get the line if a match was found.
                                    sResult = text;
                                }
                            }
                        }
                    }
                }
            }
            else
            {
                // Run the regex once on the entire string.
                Regex RE = new Regex(pattern, RegexOptions.Multiline);
                MatchCollection theMatches = RE.Matches(text);

                // Use these vars to remember the last line added to matchedLines
                // so that we do not add duplicate lines.
                int lastLineStartPos = -1;
                int lastLineEndPos = -1;

                // Get the line for each match.
                foreach (Match m in theMatches)
                {

                    int lineStartPos = GetBeginningOfLine(text, m.Index);
                    int lineEndPos = GetEndOfLine(text, (m.Index + m.Length - 1));


                    // If this is not a duplicate line, add it.
                    if (lastLineStartPos != lineStartPos &&
                        lastLineEndPos != lineEndPos)
                    {
                        string line = text.Substring(lineStartPos, lineEndPos - lineStartPos);
                        sResult = line;

                        // Reset line positions.
                        lastLineStartPos = lineStartPos;
                        lastLineEndPos = lineEndPos;
                    }
                }
            }
            return (sResult);
        }

        public static int GetBeginningOfLine(string text, int startPointOfMatch)
        {
            if (startPointOfMatch > 0)
            {
                --startPointOfMatch;
            }

            if (startPointOfMatch >= 0 && startPointOfMatch < text.Length)
            {
                // Move to the left until the first '\n char is found.
                for (int index = startPointOfMatch; index >= 0; index--)
                {
                    if (text[index] == '\n')
                    {
                        return (index + 1);
                    }
                }
                return (0);
            }
            return (startPointOfMatch);
        }

        public static int GetEndOfLine(string text, int endPointOfMatch)
        {
            if (endPointOfMatch >= 0 && endPointOfMatch < text.Length)
            {
                // Move to the right until the first '\n char is found.
                for (int index = endPointOfMatch; index < text.Length; index++)
                {
                    if (text[index] == '\n')
                    {
                        return (index);
                    }
                }
                return (text.Length);
            }
            return (endPointOfMatch);
        }


        private void btnMobi2MobiDir_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderDialog = new FolderBrowserDialog();
            folderDialog.ShowNewFolderButton = false;
            folderDialog.SelectedPath = @"C:\";
            folderDialog.Description = "Select the directory the Mobi2Mobi Win32 or Perl file resides in.";

            if (folderDialog.ShowDialog() == DialogResult.OK)
            {
                tbMobi2MobiDir.Text = folderDialog.SelectedPath;
                IniFile ini = new IniFile(".\\m2mcfg.ini");
                ini.IniWriteValue("Config", "MobiDir", tbMobi2MobiDir.Text);
            }

            string sMobi2MobiPL = tbMobi2MobiDir.Text + "\\mobi2mobi.pl";
            string sMobi2MobiEXE = tbMobi2MobiDir.Text + "\\mobi2mobi.exe";
            int iMobi2MobiCount = 0;

            if (File.Exists(sMobi2MobiPL) == true)
            {
                cbUsePerl.Visible = true;
                cbUsePerl.Checked = true;
                iMobi2MobiCount = iMobi2MobiCount + 1;
            }
            else
            {
                cbUsePerl.Visible = false;
            }

            if (File.Exists(sMobi2MobiEXE) == true)
            {
                cbUseWin32.Visible = true;
                cbUseWin32.Checked = true;
                iMobi2MobiCount = iMobi2MobiCount + 1;
            }
            else
            {
                cbUseWin32.Visible = false;
            }

            if (iMobi2MobiCount > 0)
            {
                lblMobi2MobiNotFound.Visible = false;
            }
            else
            {
                lblMobi2MobiNotFound.Visible = true;
            }
        }

        private void tbPublisherDetail_TextChanged(object sender, EventArgs e)
        {

        }

        private void pbCoverImage_Click(object sender, EventArgs e)
        {

        }

        private void btnCoverImage_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            openFileDialog1.InitialDirectory = @"" + tbWorkingDir.Text + "";
            openFileDialog1.Filter = "Image File (*.jpg, *.png)|*.jpg;*.png";
            openFileDialog1.Title = "Select a Cover Image for your eBook";

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                sOpenedImage = openFileDialog1.FileName;
                tbCoverImage.Text = sOpenedImage;
                pbCoverImage.Image = Image.FromFile(sOpenedImage);
            }
        }

        private void cbCoverImage_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbCoverImage.Checked == true)
            {
                if (sOpenedImage.Length > 0)
                {
                    sOpenedImageOutput = "--coverimage " + "\"" + sOpenedImage + "\"" + " ";
                }
                else
                {
                    sOpenedImage = "";
                    cbCoverImage.Checked = false;
                    MessageBox.Show("Please open an Image before checking this box again.");
                }
            }

            if (this.cbCoverImage.Checked == false)
            {
                sOpenedImageOutput = "";
            }
        }

        private void cbThumbnail_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbThumbnail.Checked == true)
            {
                if (sOpenedImage.Length > 0)
                {
                    sOpenedTNImageOutput = "--addthumbnail " + "\"" + sOpenedImage + "\"" + " ";
                }
                else
                {
                    sOpenedImage = "";
                    cbThumbnail.Checked = false;
                    MessageBox.Show("Please open an Image before checking this box again.");
                }
            }

            if (this.cbThumbnail.Checked == false)
            {
                sOpenedTNImageOutput = "";
            }
        }

        private void cbGen3Fix_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbGen3Fix.Checked == true)
            {
                if (sOpenedImage.Length > 0)
                {
                    sGen3FixOutput = "--gen3imagefix ";
                }
                else
                {
                    sOpenedImage = "";
                    cbGen3Fix.Checked = false;
                    MessageBox.Show("Please open an Image before checking this box again.");
                }
            }

            if (this.cbGen3Fix.Checked == false)
            {
                sGen3FixOutput = "";
            }
        }

        private void InitFields()
        {
            sOpenedImage = "";
            sOpenedImageOutput = "";
            sOpenedTNImage = "";
            sOpenedTNImageOutput = "";
            sGen3FixOutput = "";
            sFilterExtn = "";
            sMobiDataPath = "";
            sMobiDataPathBatch = "";
            sTmpBookPath = "";
            sTmpBookPathBatch = "";
            sMobi2MobiPath = "";
            sM2MBatchPath = "";
            sOutPutPath = "";
            sOpenedBook = "";
            sBookTitle = "";
            sLongTitle = "";
            sBookAuthor = "";
            sBookAuthorResult = "";
            sBookAuthorOutput = "";
            sBookPublisher = "";
            sBookPublisherResult = "";
            sBookPublisherOutput = "";
            sBookSubject = "";
            sBookSubjectResult = "";
            sBookSubjectOutput = "";
            sBookDescription = "";
            sBookDescriptionResult = "";
            sBookDescriptionOutput = "";
            sBookLanguage = "";
            sBookLanguageResult = "";
            sBookLanguageOutput = "";
            sFilenameTrimmed = "";
            sFilenameOutput = "";
            sFilenameOutputMod = "";
            sFilenameOutputCheck = "";
            sFilenameOutputFinal = "";
            sDatafileDetail = "";
            sLongfileDetail = "";
            sCoverImagePreview = "";
            sThumbnailImagePreview = "";
            sCoverImagePreviewPath = "";
            sThumbnailImagePreviewPath = "";
            sCoverImagePreviewPathBatch = "";
            sThumbnailImagePreviewPathBatch = "";
            sExth1 = "";
            sExth1Output = "";
            sExth2 = "";
            sExth2Output = "";
            sExth3 = "";
            sExth3Output = "";

            cbOutputFile.Checked = false;
            cbBookTitle.Checked = false;
            cbAuthorDetail.Checked = false;
            cbPublisherDetail.Checked = false;
            cbSubject.Checked = false;
            cbDescription.Checked = false;
            cbLanguage.Checked = false;
            cbThumbnail.Checked = false;
            cbCoverImage.Checked = false;
            cbGen3Fix.Checked = false;
            cbExth1.Checked = false;
            //cbExth2.Checked = false;
            //cbExth3.Checked = false;
            rtbMobiOutput.Text = "";
            pbCoverImage.Image = null;
            pbThumbnail.Image = null;

            cmbLanguage.SelectedIndex = -1;
            cmbExthType1.SelectedIndex = -1;
            //cmbExthType2.SelectedIndex = -1;
            //cmbExthType3.SelectedIndex = -1;
            
            tbOpenedFile.Text = "";
            tbOutputFile.Text = "";
            tbBookTitle.Text = "";
            tbAuthorDetail.Text = "";
            tbPublisherDetail.Text = "";
            tbSubject.Text = "";
            tbDescription.Text = "";
            tbLanguage.Text = "";
            tbCoverImage.Text = "";
            tbExthdata1.Text = "";
            //tbExthdata2.Text = "";
            //tbExthdata3.Text = "";
        }

        private void BuildPaths()
        {
            sCoverImagePreviewPath = tbMobi2MobiDir.Text + "\\cover.m2m";
            sCoverImagePreviewPathBatch = "\"" + sCoverImagePreviewPath + "\"";

            sThumbnailImagePreviewPath = tbMobi2MobiDir.Text + "\\thumb.m2m";
            sThumbnailImagePreviewPathBatch = "\"" + sThumbnailImagePreviewPath + "\"";

            sMobiDataPath = tbMobi2MobiDir.Text + "\\mobidata.m2m";
            sMobiDataPathBatch = "\"" + sMobiDataPath + "\"";

            sTmpBookPath = tbMobi2MobiDir.Text + "\\tmpBook.m2m";
            sTmpBookPathBatch = "\"" + sTmpBookPath + "\"";

            if (this.cbUsePerl.Checked == true)
            {
                sMobi2MobiPath = tbMobi2MobiDir.Text + "\\mobi2mobi.pl";
                sMobi2MobiPath = "\"" + sMobi2MobiPath + "\"";
            }
            else
            {
                sMobi2MobiPath = tbMobi2MobiDir.Text + "\\mobi2mobi.exe";
                sMobi2MobiPath = "\"" + sMobi2MobiPath + "\"";
            }
            
            sM2MBatchPath = tbMobi2MobiDir.Text + "\\m2mcmds.bat";
        }

        private void DelFile(string path)
        {
            if (File.Exists(path) == true)
            {
                File.Delete(path);
            }
        }

        private void BuildBatch(string path, string output)
        {
            StreamWriter swBat = File.CreateText(path);
            swBat.WriteLine(output);
            swBat.Close();
        }

        private string BatchProcess(string batchfile, bool output)
        {
            ProcessStartInfo sinf = new ProcessStartInfo(batchfile);
            sinf.RedirectStandardOutput = true;
            sinf.UseShellExecute = false;
            sinf.CreateNoWindow = true;
            Process p = new Process();
            p.StartInfo = sinf;
            p.Start();

            while (p.HasExited != true)
            {
                Thread.Sleep(1);
            }

            if (output == true)
            {
                string res = "";
                res = p.StandardOutput.ReadToEnd();
                p.Close();
                return res;
            }
            else
            {
                p.Close();
                return null;
            }
        }

        private void UpdateCoverImagePB(string imagefile)
        {
            if (File.Exists(imagefile) == true)
                {
                    FileStream fsImage = new FileStream(imagefile, FileMode.Open, FileAccess.Read);
                    Image tmpImage = Image.FromStream(fsImage);
                    pbCoverImage.Image = tmpImage;
                    fsImage.Dispose();
                    fsImage.Close();
                }
        }

        private void UpdateThumbnailImagePB(string imagefile)
        {
            if (File.Exists(imagefile) == true)
            {
                FileStream fsImage = new FileStream(imagefile, FileMode.Open, FileAccess.Read);
                Image tmpImage = Image.FromStream(fsImage);
                pbThumbnail.Image = tmpImage; 
                fsImage.Dispose();
                fsImage.Close();
            }
        }

        private string FindMatch(string matchString)
        {
            string match = "";

            for (int loop = 0; loop < sSplitData.Length; loop++)
            {
                if (sSplitData[loop].Contains(matchString))
                {
                    match = sSplitData[loop];
                    return match;
                }
            }
            match = "";
            return match;
        }

        private void UpdateBookFields(string datapath, bool open)
        {
            StreamReader objInput = new StreamReader(datapath, System.Text.Encoding.Default);
            content = objInput.ReadToEnd().Trim();
            sSplitData = System.Text.RegularExpressions.Regex.Split(content, "\r", RegexOptions.None);
            objInput.Dispose();
            objInput.Close();

            sDatafileDetail = FindMatch("Database Name:");
            sLongfileDetail = FindMatch("LONGTITLE:");
            sBookAuthorResult = FindMatch("EXTH    item: 100 - Author -");
            sBookPublisherResult = FindMatch("EXTH    item: 101 - Publisher -");
            sBookSubjectResult = FindMatch("EXTH    item: 105 - Subject -");
            sBookDescriptionResult = FindMatch("EXTH    item: 103 - Description -");
            sBookLanguageResult = FindMatch("MOBIHEADER language:");

            if (open == true)
            {
                if (sFilterExtn.Contains("prc"))
                {
                    sSplit = sDatafileDetail.Split(':');
                    tbBookTitle.Text = RightOf(sSplit[1], " ");
                    Array.Clear(sSplit, 0, sSplit.Length);
                    cbBookTitle.Checked = true;
                }
            }

            if (sFilterExtn.Contains("mobi"))
            {
                sSplit = sLongfileDetail.Split(':');
                tbBookTitle.Text = RightOf(sSplit[1], " ");
                Array.Clear(sSplit, 0, sSplit.Length);
            }
            
            if (sBookAuthorResult.Length > 0)
            {
                sSplit = sBookAuthorResult.Split('-');
                tbAuthorDetail.Text = RightOf(sSplit[3], " ");
                Array.Clear(sSplit, 0, sSplit.Length);
            }

            if (sBookPublisherResult.Length > 0)
            {
                sSplit = sBookPublisherResult.Split('-');
                tbPublisherDetail.Text = RightOf(sSplit[3], " ");
                Array.Clear(sSplit, 0, sSplit.Length);
            }

            if (sBookSubjectResult.Length > 0)
            {
                sSplit = sBookSubjectResult.Split('-');
                tbSubject.Text = RightOf(sSplit[3], " ");
                Array.Clear(sSplit, 0, sSplit.Length);
            }

            if (sBookDescriptionResult.Length > 0)
            {
                sSplit = sBookDescriptionResult.Split('-');
                tbDescription.Text = RightOf(sSplit[3], " ");
                Array.Clear(sSplit, 0, sSplit.Length);
            }

            if (sBookLanguageResult.Length > 0)
            {
                sSplit = sBookLanguageResult.Split('-');
                string sBuildLanguage = "";

                if (sSplit[3].Length > 1)
                {
                    sBuildLanguage = RightOf(sSplit[3], " ");
                }

                if (sSplit[4].Length > 1)
                {
                    sBuildLanguage = sBuildLanguage + "- " + RightOf(sSplit[4], " ");
                }
                tbLanguage.Text = sBuildLanguage;
                Array.Clear(sSplit, 0, sSplit.Length);
            }
        }

        private void lblPublisherDetail_Click(object sender, EventArgs e)
        {

        }

        private void lblAuthorDetail_Click(object sender, EventArgs e)
        {

        }

        private void lblBookTitle_Click(object sender, EventArgs e)
        {

        }

        private void lblOutputFile_Click(object sender, EventArgs e)
        {

        }

        private void lblOutoutFile_Click(object sender, EventArgs e)
        {

        }

        private void lblM2MLoc_Click(object sender, EventArgs e)
        {

        }

        private void lblWorkingDir_Click(object sender, EventArgs e)
        {

        }

        private void lblOpenedFile_Click(object sender, EventArgs e)
        {

        }

        private void tbMobi2MobiDir_TextChanged(object sender, EventArgs e)
        {

        }

        private void tbWorkingDir_TextChanged(object sender, EventArgs e)
        {

        }

        private void tbOpenedFile_TextChanged(object sender, EventArgs e)
        {

        }

        private void cbUsePerl_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbUsePerl.Checked == true)
            {
                IniFile ini = new IniFile(".\\m2mcfg.ini");
                ini.IniWriteValue("Config", "UsePerl", "true");
                ini.IniWriteValue("Config", "UseWin32", "false");
                cbUseWin32.Checked = false;
            }
            else
            {
                IniFile ini = new IniFile(".\\m2mcfg.ini");
                ini.IniWriteValue("Config", "UsePerl", "false");
                ini.IniWriteValue("Config", "UseWin32", "true");
                cbUseWin32.Checked = true;
            }

            if (cbUseWin32.Visible == false)
            {
                cbUsePerl.Checked = true;
            }
        }

        private void cbUseWin32_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbUseWin32.Checked == true)
            {
                IniFile ini = new IniFile(".\\m2mcfg.ini");
                ini.IniWriteValue("Config", "UseWin32", "true");
                ini.IniWriteValue("Config", "UsePerl", "false");
                cbUsePerl.Checked = false;
            }
            else
            {
                IniFile ini = new IniFile(".\\m2mcfg.ini");
                ini.IniWriteValue("Config", "UseWin32", "false");
                ini.IniWriteValue("Config", "UsePerl", "true");
                cbUsePerl.Checked = true;
            }

            if (cbUsePerl.Visible == false)
            {
                cbUseWin32.Checked = true;
            }
        }

        private void lblMobi2MobiNotFound_Click(object sender, EventArgs e)
        {

        }

        private void cbSubject_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbSubject.Checked == true)
            {
                sBookSubject = tbSubject.Text;
                if (sBookSubject.Length > 0)
                {
                    sBookSubjectOutput = "--subject " + "\"" + sBookSubject + "\"" + " ";
                }
                else
                {
                    sBookSubject = "";
                    cbSubject.Checked = false;
                    MessageBox.Show("Please enter subject details before checking this box again.");
                }
            }

            if (this.cbSubject.Checked == false)
            {
                sBookSubjectOutput = "";
            }
        }

        private void cbDescription_CheckedChanged(object sender, EventArgs e)
        {
            if (this.cbDescription.Checked == true)
            {
                sBookDescription = tbDescription.Text;
                if (sBookDescription.Length > 0)
                {
                    sBookDescriptionOutput = "--description " + "\"" + sBookDescription + "\"" + " ";
                }
                else
                {
                    sBookDescription = "";
                    cbDescription.Checked = false;
                    MessageBox.Show("Please enter description details before checking this box again.");
                }
            }

            if (this.cbDescription.Checked == false)
            {
                sBookDescriptionOutput = "";
            }
        }

        private void cbLanguage_CheckedChanged(object sender, EventArgs e)
        {
            string sSelectedLanguage = "";

            if (this.cbLanguage.Checked == true)
            {
                sSelectedLanguage = cmbLanguage.Text;
                if (sSelectedLanguage.Length > 0)
                {
                    sBookLanguageOutput = "--language " + "\"" + sSelectedLanguage + "\"" + " ";
                }
                else
                {
                    sSelectedLanguage = "";
                    cbLanguage.Checked = false;
                    MessageBox.Show("Please select a language before checking this box again.");
                }
            }

            if (this.cbLanguage.Checked == false)
            {
                sBookLanguageOutput = "";
            }
        }

        private void cmbLanguage_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void cbExth1_CheckedChanged(object sender, EventArgs e)
        {
            string sSelectedType = "";

            if (this.cbExth1.Checked == true)
            {
                sSelectedType = cmbExthType1.Text;
                if (sSelectedType.Length > 0)
                {
                    sExth1Output = "--exthtype " + sSelectedType + " " + "--exthdata " + "\"" + tbExthdata1.Text + "\"" + " ";
                }
                else
                {
                    sSelectedType = "";
                    cbExth1.Checked = false;
                    MessageBox.Show("Please select a Exth Type before checking this box again.");
                }
            }

            if (this.cbExth1.Checked == false)
            {
                sExth1Output = "";
            }
        }

        

        private void lblInstruct_Click(object sender, EventArgs e)
        {

        }

       
        private void tbSubject_TextChanged(object sender, EventArgs e)
        {

        }

        private void tbDescription_TextChanged(object sender, EventArgs e)
        {

        }

        private void cmbExthType1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

    }
}
